#include <vector>
#include <string>

#ifndef SNAKE_CLASS_DEF

#define SNAKE_CLASS_DEF

class Snake {
	public:
		Snake(int, int, int);
		void grow();
		bool isSnakeHere(int, int) const;
		void direction(string);
		void setSpeed(int s) { spd = s; }
		int speed() { return spd; }
		vector <float> color() { return scolor; }
		void move();
		vector <int> headPosition() { return snk[snk.size()-1]; }
		bool flash();
		bool getCrash() const;
		double getScore() const;
	private:
		vector < vector<int> > snk;
		unsigned int length;
		int spd;
		string dir, lastdir;
		vector <float> scolor;
		int flashIncrement;
		int applesEaten;
		bool snakeCrash;
		double score;
};

#endif
