#include <vector>
#include <string>

using namespace std;

#include "snakeclass.h"

Snake::Snake(int x, int y, int l=5) :
								length(l), spd(500), dir("right"), flashIncrement(0),
								applesEaten(0), snakeCrash(false), score(0) {
	scolor = vector <float> (3, 0);
	scolor[1] = 1;
	vector <int> v;
	v.push_back(x);
	v.push_back(y);
	snk.push_back(v); //snakes head co-ordinate!
}

bool Snake::isSnakeHere(int x, int y) const {
	for (unsigned int i=0; i<snk.size(); i++)
		if ( snk[i][0] == x
			&& snk[i][1] == y )
			return true;
	return false;
}

void Snake::direction(string d) {
	if (d=="up" && lastdir!="down")
		dir = "up";
	else if (d=="down" && lastdir!="up")
		dir = "down";
	else if (d=="right" && lastdir!="left")
		dir = "right";
	else if (d=="left" && lastdir!="right")
		dir = "left";
}

void Snake::move() {
	vector <int> v = snk[snk.size()-1];
	if (dir=="up")
		v[1]+=1;
	else if (dir=="down")
		v[1]-=1;
	else if (dir=="left")
		v[0]-=1;
	else if (dir=="right")
		v[0]+=1;

	//check if we hit ourselves
	if (isSnakeHere(v[0], v[1]))
		snakeCrash = true;

	snk.push_back(v);
	if (snk.size() > length)
		snk.erase(snk.begin());
	lastdir = dir;
}

bool Snake::flash() {
	if(flashIncrement < 6) {
		if (flashIncrement%2 == 0)
			scolor[1] = 0;
		else scolor[1] = 1;
		flashIncrement++;
		return true;
	}
	return false;
}

void Snake::grow() {
	length+= 3;
	applesEaten++;
	if (applesEaten%5 == 0)
		spd*= 0.9;			// speed up every 5 apples!
	score+= length*applesEaten;
}

bool Snake::getCrash() const { return snakeCrash; }

double Snake::getScore() const { return score; }
