#include <iostream>
#include <stdlib.h> //Needed for "exit" function

//Include OpenGL header files, so that we can use OpenGL
#ifdef __APPLE__
#include <OpenGL/OpenGL.h>
#include <GLUT/glut.h>
#else
#include <GL/glut.h>
#endif

using namespace std;

#include "snakeclass.cpp"
#include "mapclass.cpp"

//globals. bad!
Snake snake(3, 19-3, 5);
Map map(20, 20);
bool gamePersp;

//prototypes
void drawbox(int, int, int);

//Called when a key is pressed
void handleKeypress(unsigned char key,	//The key that was pressed
					int x, int y) {		//The current mouse coordinates
	const int KEY_ESC = 27;

	switch (key) {
		case KEY_ESC: //Escape key
			cout << endl << "Thanks for playing!" << endl;
			exit(0); //Exit the program
		case 'd':  case 'D':
			snake.direction("right");
			break;
		case 'a':  case 'A':
			snake.direction("left");
			break;
		case 'w':  case 'W':
			snake.direction("up");
			break;
		case 's':  case 'S':
			snake.direction("down");
			break;
		case 'p':  case 'P':
			gamePersp=!gamePersp;
			glutPostRedisplay(); 		//Tell GLUT that the display has changed
			break;
	}
}

void handleSpecialKey(int key, int x, int y) {
	switch (key) {
		case GLUT_KEY_RIGHT:
			snake.direction("right");
			break;
		case GLUT_KEY_LEFT:
			snake.direction("left");
			break;
		case GLUT_KEY_UP:
			snake.direction("up");
			break;
		case GLUT_KEY_DOWN:
			snake.direction("down");
			break;
	}
}


//Initializes 3D rendering
void initRendering() {
	//Makes 3D drawing work when something is in front of something else
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_COLOR_MATERIAL); //colours, obviously
}

//Called when the window is resized
void handleResize(int w, int h) {
	//Tell OpenGL how to convert from coordinates to pixel values
	glViewport(0, 0, w, h);

	glMatrixMode(GL_PROJECTION); //Switch to setting the camera perspective

	//Set the camera perspective
	glLoadIdentity(); //Reset the camera
	gluPerspective(45.0,                  //The camera angle
				   (double)w / (double)h, //The width-to-height ratio
				   1.0,                   //The near z clipping coordinate
				   200.0);                //The far z clipping coordinate
}

//Draws the 3D scene
void drawScene() {
	//Clear information from last draw
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glMatrixMode(GL_MODELVIEW); //Switch to the drawing perspective
	glLoadIdentity(); //Reset the drawing perspective

	glTranslatef(-9.5, -9.5, 0); //move the box left and down by 9.5 units

	if (gamePersp) {
		glRotatef(-30, 1, 0, 0); 	//rotate 30dg away from the camera
									//around the x axis (which is the bottom
									//annoyingly
		glTranslatef(0, 14, 0);		//up a bit
		glTranslatef(0, 0, 11);		//in a bit
	}

	glBegin(GL_QUADS); //Begin quadrilateral coordinates

		// draw 20 blocks!
		float z=-30.0;
		bool colorAlt = true;
		//int xmax, ymax; xmax=ymax=20;
		vector <float> c = snake.color();

		for (int y=0; y<map.height(); y++) {
			for (int x=0; x<map.width(); x++) {
				if (map.isWall(x, y)) {
					if (colorAlt)
						glColor3f(0.55, 0, 0);
					else glColor3f(0.9, 0, 0);
					drawbox(x,y,z);
					colorAlt=!colorAlt;
				}
				if (snake.isSnakeHere(x, y)) {
					glColor3f(c[0], c[1], c[2]);
					drawbox(x,y,z);
				}
				if (map.isApple(x, y)) {
					glColor3f(0.5, 0.5, 1);
					drawbox(x,y,z);
				}
			}
			colorAlt=!colorAlt;
		}

	glEnd(); //End quadrilateral coordinates

	glutSwapBuffers(); //Send the 3D scene to the screen
}

void drawbox(int x, int y, int z) {
	glVertex3f(x-0.5, y-0.5, z); //drawn clockwise, strangely enough
	glVertex3f(x+0.5, y-0.5, z); //starts at top right
	glVertex3f(x+0.5, y+0.5, z);
	glVertex3f(x-0.5, y+0.5, z); //x, y denotes center of shape
}

void update(int value) {
	if ( map.outOfBounds(snake.headPosition()) == 1
		|| snake.getCrash() ) {
		if (!snake.flash()) {
			cout << endl << "Final score for this round: " << snake.getScore() << endl << endl;
			snake = Snake(3, 19-3, 5);
		}
	}
	else {
		if ( map.outOfBounds(snake.headPosition()) == 2 ) {
			map.newApple(snake);
			snake.grow();
			cout << "Current score: " << snake.getScore() << endl;
		}
		snake.move();
	}

	glutPostRedisplay(); //Tell GLUT that the display has changed

	//Tell GLUT to call update again
	glutTimerFunc(snake.speed(), update, 0);
}


void setUpGame() {
	gamePersp = false;
	map.newApple(snake);

	cout << "GL Snake! - by Doug Inman" << endl
		<< "  totem9.net" << endl << endl;
	cout << "Controls:" << endl
		<< "  arrows / wasd   - move" << endl
		<< "  p               - perspective mode" << endl
		<< "  esc             - exit" << endl << endl;

	/*
	cout << "Set difficulty level (1 - 3): ";
	int diff = 1;
	cin >> diff;
	if (diff == 3)
	*/
}


int main(int argc, char** argv) {
	//Initialize GLUT
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(800, 600); //Set the window size

	//Create the window
	glutCreateWindow("GL Snake :: totem9.net");
	initRendering(); //Initialize rendering

	setUpGame();

	//Set handler functions for drawing, keypresses, and window resizes
	glutDisplayFunc(drawScene);
	glutReshapeFunc(handleResize);
	glutKeyboardFunc(handleKeypress);
	glutSpecialFunc(handleSpecialKey);

	glutTimerFunc(snake.speed(), update, 0); //Add a timer

	glutMainLoop(); //Start the main loop.  glutMainLoop doesn't return.
	return 0; //This line is never reached
}
