#include <vector>
#include <string>
#include <cassert>
#include <cstdlib>
#include <ctime>

using namespace std;

#include "snakeclass.h"

class Map {
	public:
		Map(int,int);
		static const char WALL='*', FLOOR=' ';
		int width() const;
		int height() const;
		bool isWall(int, int) const;
		int outOfBounds(vector <int> );
		void newApple(const Snake& );
		bool isApple(int, int) const;
	private:
		vector <string> mappy;
		vector <int> apple;
};

bool Map::isWall(int x, int y) const { return mappy[y][x] == WALL; }
bool Map::isApple(int x, int y) const {	return x==apple[0] && y==apple[1]; }
int Map::width() const { return mappy[0].length(); }
int Map::height() const { return mappy.size(); }

Map::Map(int xmax, int ymax) {
	assert(xmax>=1 && ymax>=1); // sensible assertion.

	// set up an empty map, then put in the walls
	for (int y=0; y<ymax; y++) {
		string s;
		for (int x=0; x<xmax; x++)
			if (x==0 || x==xmax-1 || y==0 || y==ymax-1)
				s+=WALL;
			else s+=FLOOR;
		mappy.push_back(s);
	}

	// set up apple class
	apple.push_back(0);
	apple.push_back(0);
}

int Map::outOfBounds(vector <int> head) {
	if ( mappy[head[1]][head[0]] == WALL )
		return 1;
	else if ( isApple(head[0], head[1]) )
		return 2;
	else return 0;
}

void Map::newApple(const Snake& s) {
	// randomize timer. srand == 'seed rand'
	srand((unsigned)time(0));

	while (true) {
		// generate two random co-ordinates
		int x = (rand()%width());
		int y = (rand()%height());

		// check if we hit the wall or a snake
		if (!isWall(x, y) && !s.isSnakeHere(x, y)) {
			apple[0] = x;
			apple[1] = y;
			break;
		}
	}
}
