/*
	Curses Snake
	by Doug Inman
	03-Dec-09
	
	totem9.net
*/
#include <iostream>
#include <string>
#include <sstream>
#include <vector>
#include <curses.h>
#include <ctime>
#include <stdlib.h>

//make sleep work:
#ifdef WIN32
	#include <windows.h>
	#define SLEEP(x) Sleep(x)   /* Windows version */
#else
	#include <unistd.h>
	#define SLEEP(x) usleep((x) * 1000)   /* Linux version */
#endif

using namespace std;

//consts
const int KEY_ESC=27; //ncurses doesn't have this, so I have to do it
const int mapwidth=80;
const int mapheight=22;
const string WALL="*";
const string SNAKEGFX="@";

//globals
vector <string> map(22);
int movx=1, movy=0;
vector <int> snakex(1, 3);
vector <int> snakey(1, 3);
int snakelength=5;
int lives=5;
int snakespeed=100;
int point_number=0, point_run=0;
int score=0;
int point_number_x, point_number_y;


//changes anything to a string. useful for ehoing with ncurses
template <class T>
inline std::string to_string (const T& t)
{
	std::stringstream ss;
	ss << t;
	return ss.str();
}


//waits ms seconds
void wait_sec (const double sec) {
	double theTime = clock() + (sec*1000);
	while(clock() < theTime)
		;
}


//obvious...
void loadmap() {
	//base map - a box.
	for (int i=0; i<22; i++)
		for (int j=0; j<80; j++)
			if (i==0 || j==0 || i==21 || j==79)
				map[i] += WALL;
			else
				map[i] += " ";
}


//obvious
void drawmap() {
	for (int y=0; y<mapheight; y++) {
		mvprintw( y, 0, "%s", map[y].c_str() );
		printw("\n");
	}
	for (int i=0; i<snakex.size(); i++)
		mvprintw( snakey[i], snakex[i], "%s", SNAKEGFX.c_str() );
}


//obvious
void drawscore() {
	string s;

	//lives left
	s = "Lives: " + to_string(lives);
	mvprintw( 23, 1, "%s", s.c_str() );
	//score
	s = "Score: " + to_string(score);
	mvprintw( 23, 11, "%s", s.c_str() );

	// some debug info
	int xoffset=65;
	//string s = to_string(keyb);
	//mvprintw ( 23, xoffset, s.c_str() ); // write out what key we pressed
	s = "x:" + to_string(snakex[0]) + " y:" + to_string(snakey[0]);  // x-y co-ords
	mvprintw( 23, xoffset+4, "%s", s.c_str() ); // print em
}


//called when we hit a number
void newpointnumber() {
	point_run += 1;
	score += point_number * point_run;
	point_number += 1;
	point_number %= 10;
	int x, y;
	bool spotfound = false;
	srand ( time(NULL) ); //make random numbers random

	while (!spotfound) {
		x = rand() % (map[0].length() - 2) + 1;
		y = rand() % (map.size() - 2) + 1 ;

		if ( map[y].substr(x, 1) == " " ) { //if the map is empty
			spotfound = true;
			for (int i=0; i<snakex.size(); i++)
				if (snakex[i] == x && snakey[i] == y)
					spotfound = false;
		}
	}
	if (point_number != 1)
		map[point_number_y][point_number_x] = ' ';
	map[y][x] = point_number + '0';
	point_number_x = x;
	point_number_y = y;

	/*
	cout << x << " " << y << endl;
	cout << "a" << map[y].substr(x, 1) << "b" << endl;
	exit(0);
	*/
}


int movechar(int keyb) {
	const int MOVEOK 	 = 0;
	const int SNAKECRASH = 1;
	const int EXITKEY 	 = 2;
	const int WINLEVEL 	 = 3;

	//kick off with special keys
	if (keyb == KEY_ESC)
		return EXITKEY;

	// then movement keys
	else if (keyb == KEY_UP	&& movy != 1) {  //can't go back on yourself!
		movy=-1;
		movx=0;
	} else if (keyb == KEY_DOWN && movy != -1) {
		movy=1;
		movx=0;
	} else if (keyb == KEY_LEFT && movx != 1) {
		movx=-1;
		movy=0;
	} else if (keyb == KEY_RIGHT && movx != -1) {
		movx=1;
		movy=0;
	}

	//check if we hit ourselves
	for (int i=0; i<snakex.size(); i++)
		if ( snakex[0]+movx == snakex[i]
			&& snakey[0]+movy == snakey[i]
			)
			return SNAKECRASH;

	//check if we hit an obsticle
	string checknext = map[snakey[0]+movy].substr(snakex[0]+movx, 1);
	if ( checknext == WALL )
		return SNAKECRASH;

	//otherwise move the snake!
	snakex.insert(snakex.begin(), 1, 0); //make a new empty int at position 0
	snakex[0] = snakex[1] + movx; // set it to the last value + movx
	snakey.insert(snakey.begin(), 1, 0);
	snakey[0] = snakey[1] + movy;
	if (snakex.size() > snakelength) {
		snakex.pop_back();
		snakey.pop_back();
	}

	//check of we just ran over a number
	if ( checknext[0] >= '1' && checknext[0] <= '9' ) {
		snakelength += point_number;
		//+score?
		newpointnumber();
	} else if (checknext[0] == '0')
		return WINLEVEL;

	return MOVEOK;
}



int main() {
	int keyb;

	loadmap();
	newpointnumber();

	initscr(); // Start curses mode
	noecho(); // don't echo characters
	keypad(stdscr, true); // switch on keyboard input for standard-screen
	nodelay(stdscr, true); // switch off keyboard delay

	int dead=0;
	while (!dead) {
		dead = movechar(keyb);

		//dead=3;
		if (dead==1) {
			int xoffset=34, yoffset=10;
			mvprintw( yoffset + 0, xoffset, "*************" );
			mvprintw( yoffset + 1, xoffset, "* You died! *" );
			mvprintw( yoffset + 2, xoffset, "*************" );
			refresh();
			SLEEP(3000);
			lives-=1;
			if (lives > 0) {
			    //exit(1);
				dead = 0;
				//snakex.clear();	snakey.clear();
				while(snakex.size() > 0) {
				    snakex.pop_back();
				    snakey.pop_back();
                }
				snakex.push_back(3); snakey.push_back(3);
				snakelength = 5;
				movx=1; movy=0;
			}
		} else if (dead==3) {
			int xoffset=35, yoffset=10;
			mvprintw( yoffset + 0, xoffset, "************" );
			mvprintw( yoffset + 1, xoffset, "* You win! *" );
			mvprintw( yoffset + 2, xoffset, "************" );
			refresh();
			SLEEP(3000);
			//increment level
		}

		clear(); // clear screen
		drawmap();
		drawscore();

		refresh(); // Print it on to the real screen
		SLEEP(snakespeed);
		keyb = getch(); // Wait for user input
	}

	endwin();					/* End curses mode		  			*/
}
