' [ Tile Engine v3.0b ] 
' 
'
'  Program: Tile Engine 3
'     Type: Graphics demo, Rpg starter thingy...
'     Date: 6.18.98
'   Author: Tek / neozones@geocities.com
'           www.geocities.com/~neozones
'
' Okay, here is Tile Engine 3.0b. As long as 50 million people in the QBasic
' community are making rpgs based on tile engines, they may as well have
' something to look at, if they don't know how to make a basic engine, so
' here you are. Look into my world.
'
' Please view tileeng3.txt for further info.
'
' Give credit where credit's due. Or then again, who really cares...
'
'

DEFINT A-Z                              ' All variables are default integers.
'$DYNAMIC                               ' Dynamically sort memory for more...

DECLARE SUB InitVars ()                 ' Initializes variables.
DECLARE SUB LoadMap ()                  ' Loads a map.
DECLARE SUB LoadTiles ()                ' Load the tiles by simple Bload.
DECLARE SUB MoveUp ()                   ' Handles moving `up' event.
DECLARE SUB MoveDown ()                 ' Handles moving `down' event.
DECLARE SUB MoveLeft ()                 ' Handles moving `left' event.
DECLARE SUB MoveRight ()                ' Handles moving `right' event.
DECLARE SUB PutPlayerPic ()             ' Puts the player pic.
DECLARE SUB PutTile (x, y, TileNumber)  ' Put a tile.
DECLARE SUB SetupPalette ()             ' Setup n!Media palette.
DECLARE SUB ShowMap ()                  ' Show the map...

TYPE WorldDataType                      ' WorldData holds generic world info.
 Rows            AS INTEGER             ' Number of rows in world.
 Cols            AS INTEGER             ' Number of cols in world.
 TopRow          AS INTEGER             ' Current player row in world.
 TopCol          AS INTEGER             ' Current player col in world
 Action          AS INTEGER             ' So we only do things when needed.
 AnimCycle       AS INTEGER             ' Which frame player is on.
 Direc           AS INTEGER             ' What direction player is going in.
 PlayerY         AS INTEGER             ' Adjusted player y pos for more 3d.
END TYPE

TYPE MapType                            ' Map type, easy to add tile values.
 Tile            AS INTEGER             ' Identifies tile in any spot...
END TYPE

CONST North = 1, South = 2, East = 3, West = 4  ' Tracks dirs of player.
CONST True = -1, False = 0                      ' Boolean vals for easiness.
CONST TileDir$ = "Images"                       ' Tile directory.

DIM SHARED Tree1(129), Grass1(129), Water1(129) ' Tree, grass, water tiles.
DIM SHARED WorldData AS WorldDataType           ' WorldData variables.
DIM SHARED Map(-9 TO 60, -9 TO 60) AS MapType   ' The map, memory hog, reduce
                                                ' for more mem, smaller map.
CALL InitVars                                   ' Initialize variables.
CALL LoadMap                                    ' Load a/the map.
CALL LoadTiles                                  ' Load tiles.

SCREEN 13                                       ' Set screen mode.
CALL SetupPalette                               ' Set our palette.
CALL ShowMap                                    ' Show map...

DO                                              ' Main heart loop of program.
 kbd$ = INKEY$                                  ' `Transparent' input.
 IF kbd$ <> "" THEN                             ' If other than nothing...
  SELECT CASE kbd$                              ' ... find what key it is...
   CASE CHR$(0) + "H"                           ' Hit up arrow.
    CALL MoveUp                                 ' Call up events.
    WorldData.Action = True                     ' An action happened.
   CASE CHR$(0) + "P"                           ' Hit down arrow.
    CALL MoveDown                               ' Call down events.
    WorldData.Action = True                     ' An action happened.
   CASE CHR$(0) + "K"                           ' Hit left arrow.
    CALL MoveLeft                               ' Call left events.
    WorldData.Action = True                     ' An action happened.
   CASE CHR$(0) + "M"                           ' Hit right arrow.
    CALL MoveRight                              ' Call right events.
    WorldData.Action = True                     ' An action happened.

   CASE CHR$(27)                                ' ESC; end.
    SYSTEM
   END SELECT
 END IF

 IF WorldData.Action = True THEN                ' If an action did happen...
  CALL ShowMap                                  ' Show the map since we moved.
  WorldData.Action = False                      ' No more action.
 END IF                                         ' This is the spot where
                                                '  you would check if they
LOOP                                            '  hit a village or something.


' [ World Map Data ] 
'  No more Walk property... if the tile is less than 0, you can't walk on it,
' otherwise it's > 0 and you can walk on it... This is here for a little more
' simplicity. If you do decide to go off this engine, you'll probably want to
' make the maps separate .map files or something, and you'll have to change
' this... just make sure you understand the code.

MainMap:
DATA 40,40
DATA -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,-2,-2,-2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-2,-2,-2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1
DATA -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1

REM $STATIC
SUB InitVars

WorldData.TopCol = 20                   ' Where they start in map (col).
WorldData.TopRow = 20                   ' Where they start in map (row).
WorldData.PlayerY = 96                  ' Y pixel location for player show.
                                        ' This is raised so it sorta looks
                                        ' like they are in front of the tile
                                        ' above them...
END SUB

SUB LoadMap

RESTORE MainMap                                 ' Read data from MainMap
READ WorldData.Rows, WorldData.Cols             ' Read row and column count.

FOR i = 1 TO WorldData.Rows
 FOR j = 1 TO WorldData.Cols
  READ Map(j, i).Tile                           ' Read tile in...
 NEXT j
NEXT i

END SUB

SUB LoadTiles

CHDIR TileDir$                          ' Goto tile directory.

' We define the current memory segment as the beginning of our array to
' hole a tile. Then we bload the data from "tile.mdt" to (Array(0)).
' These are n!Media BLoad/BSave tiles... n!Media can be found on my page...
' There are also other editors that support the bsave format, but not
' necessarily the same palette, unless you want to convert it all...

DEF SEG = VARSEG(Grass1(0)): BLOAD "grass1.mdt", VARPTR(Grass1(0))
DEF SEG = VARSEG(Water1(0)): BLOAD "water1.mdt", VARPTR(Water1(0))
DEF SEG = VARSEG(Tree1(0)): BLOAD "tree1.mdt", VARPTR(Tree1(0))

CHDIR ".."                              ' Go back to initial dir.

END SUB

SUB MoveDown

' Current direction is south. IF the row beneath and in our current column
' is walkable (value > 0 ) then increment row.
' The IF Map( ...blah...) refers to the map array, with TopCol and TopRow
' values in mind...

WorldData.Direc = South

IF Map(WorldData.TopCol + 10, WorldData.TopRow + 7).Tile > 0 THEN
 WorldData.TopRow = WorldData.TopRow + 1
END IF

END SUB

SUB MoveLeft

WorldData.Direc = Left

IF Map(WorldData.TopCol + 9, WorldData.TopRow + 6).Tile > 0 THEN
 WorldData.TopCol = WorldData.TopCol - 1
END IF

END SUB

SUB MoveRight

WorldData.Direc = Right

IF Map(WorldData.TopCol + 11, WorldData.TopRow + 6).Tile > 0 THEN
 WorldData.TopCol = WorldData.TopCol + 1
END IF

END SUB

SUB MoveUp

WorldData.Direc = North

IF Map(WorldData.TopCol + 10, WorldData.TopRow + 5).Tile > 0 THEN
 WorldData.TopRow = WorldData.TopRow - 1
END IF

END SUB

SUB PutPlayerPic

' I didn't have any tiles here for the player, but I'll tell you this if you
' don't already know: To know which player pic you would show, you can do a
' Select Case WorldData.Direc, and do Case North, Case East, Case, South...
' Then you can Put appropriately.

LINE (160, WorldData.PlayerY)-STEP(15, 15), 15, B       ' Show `box' man.

END SUB

SUB PutTile (x, y, TileNumber)

SELECT CASE TileNumber                  ' Which tile to show?
 CASE -2                                ' Negative tile (unwalkable)...
  PUT (x, y), Water1, PSET              ' Show it...
 CASE -1
  PUT (x, y), Tree1, PSET
 CASE 1                                 ' Anything undefined is by default
  PUT (x, y), Grass1, PSET              ' grass.
 CASE 0
  LINE (x, y)-(x + 16, y + 16), 16, BF
END SELECT

END SUB

SUB SetupPalette

' This loads the palette, it's nothing of consequence, just move on...

DIM Pal(512)

DEF SEG = VARSEG(Pal(0))
BLOAD "nmedia.pal", 0
i = 0
FOR C = 0 TO 255
 OUT &H3C8, C
 OUT &H3C9, PEEK(i)
 OUT &H3C9, PEEK(i + 1)
 OUT &H3C9, PEEK(i + 2)
 i = i + 4
NEXT C
DEF SEG

END SUB

SUB ShowMap

' Go thru number of tiles that will be on screen, reference to map array
' keeping in mind out TopRow and TopCol values, show with PutTile sub.

FOR i = 0 TO 19
 FOR j = 0 TO 11
  CALL PutTile(i * 16, j * 16, Map(i + WorldData.TopCol, j + WorldData.TopRow).Tile)
 NEXT j
NEXT i

CALL PutPlayerPic

END SUB

