+------------------------------------------+
|  RPG Programming Tutorial                |
|                                          |
|  August/September 1997                   |
|  Issue #4                                |
|  Released: September 17th, 1997          |
|  Graphics!                               |
+------------------------------------------+

     Welcome to another installment of the RPG's in Qbasic Tutorials.  This
one deals with a subject that many of you QB programmers out there have been
asking me about, namely, how to get some great graphics into your RPG.
     I feel compelled to point out that, the type of program you use to make
your graphics does not really matter.  If you put enough effort into it, your
graphics will be good no matter what you use.  As an example, all of the tile
graphics that I've done for my RPG Lianne in... The Dark Crown, were created
in my small, featureless, tile editor.  You can download that program from my
website if you want to see what it looks like.  Now, let's get to some great
graphics.

4.1 QBASIC GRAPHICS PRIMITIVES
-------------------->>>>>

     For those who don't know, the graphics primitives are functions which
have been programmed into Qbasic that allow the programmer to create (rather
simple) images.  These are things such as LINE, CIRCLE, and so on.  If you are
already familiar with these then I suggest skipping to the next section, if
not then read on.

     The graphic commands in Qbasic can be used to add to your exisiting
images but, are not recommended to create all of your images.  As an example,
you can use the line command to create a "pipe" look to menus such as this:









You can also use the line command to create boxes.  In case you don't know,
the commands are:

LINE (X1, Y1) - (X2, Y2), Colour, B      ' This will draw a box.
LINE (X1, Y1) - (X2, Y2), Colour, BF     ' This will draw a box and fill it in
                                         ' with the current colour.

Don't forget to replace X and Y with the co-ordinates and replace Colour with
a colour number of your choice, this last part is optional, if you leave it
blank, it will draw a box with the current colour.  You must include the B and
the BF however, that is what draws the box.

     That's all of the time which I care to spend on the graphics primitives.
If you wish to know more, there are many Qbasic books which explain them, or
you could try the Qbasic help as well.  Now, on to some real graphics.

4.2 BITMAPPED GRAPHICS
-------------------->>>>>

     Well, the graphics primitves are fine, if you're just drawing lines and
circles, but what if you want some real graphics? That is where bitmapped
graphics come in.  Briefly, bitmapped graphics are images which are simply
created with dots, or in this case pixels.  Each pixel is put on an X,Y grid
in certain positions to create the images.

     So, how does this help you? Well, using Qbasic's PSET command, it is very
simple to create a bitmapped graphic.  Of course, it would take forever to
write each individual PSET command, so to make it easier, you can use the
program below, which will create a 10x10 tile, using the PSET statement.

QBASIC CODE
<<<<<---------- Begin cutting here.
SCREEN 13                                       ' We must first switch to a
                                                ' screen mode which can show
                                                ' graphics.  I'm using mode 13h
                                                ' which is 320x200 pixels and
                                                ' can display 256 colours on the
                                                ' screen at once.

' The DATA statements below are used to help us draw our image on the screen.
' Notice that the 14s in the data create a happy face.  If you run this, a
' happy face will be drawn on the screen.  Use different numbers in different
' spots in the DATA to experiment with colours and images.
DATA 00,00,14,14,14,14,14,14,00,00
DATA 00,14,00,00,00,00,00,00,14,00
DATA 14,00,00,00,00,00,00,00,00,14
DATA 14,00,00,14,00,00,14,00,00,14
DATA 14,00,00,14,00,00,14,00,00,14
DATA 14,00,00,00,00,00,00,00,00,14
DATA 14,00,14,00,00,00,00,14,00,14
DATA 14,00,00,14,14,14,14,00,00,14
DATA 00,14,00,00,00,00,00,00,14,00
DATA 00,00,14,14,14,14,14,14,00,00

FOR Y = 0 TO 9                                  ' These FOR...NEXT loops will
                                                ' help us display our graphic
    FOR X = 0 TO 9                              ' on the screen.

        READ Pixel                              ' This command reads a number
                                                ' from the DATA and stores it
                                                ' in the Pixel variable.  Note
                                                ' that each number in the DATA
                                                ' is separated by a comma. The
                                                ' comma is there so READ knows
                                                ' when to stop reading a
                                                ' number.
        
        PSET (X, Y), Pixel                      ' The PSET command will put
                                                ' a pixel at positions X and
                                                ' Y (Which are the values of
                                                ' the variables in the FOR...
                                                ' NEXT loops) and with the
                                                ' colour number that is in
                                                ' the Pixel variable

    NEXT X

NEXT Y

---------->>>>> End cutting here.

     Now, this is fine for creating pictures, even if it is a bit crude, but
what if you need to have your images displayed rapidly? That is when arrays
come in...

4.3 ARRAY GRAPHICS
-------------------->>>>>

     What is an array you ask? Well, for the purpose of graphics it is a "list"
variable which can be dimensioned to hold many items in it.  In our case, this
will be graphical data.  So how do we do this? Well, first, we need to know
how big our graphic is, then we need to know how much array space we will need
for our graphic to fit.
     Let's use the happy face from the above program, since it is 10x10, the
graphic must be 100 pixels (Multiply the X and Y dimensions to get this).  Now
that we know this, how big must the array be?
     Here's a simple equation which will help you figure it out, it goes like
this:

     (Size Of Graphic / 2) + 1 = Array Space Needed

     So, to figure out how much array space the happy face will need, we put
the appropriate numbers into the equation.  Or graphic is 100 pixels so we put
that in and calculate from there:

     (100 / 2) + 1 = 51

     There, you can do the math yourself if you want.  Now we have to put our
graphic into the array.  How do we do this? Simple, just look at the code
below and then tack it onto the code which draws the happy face.

QBASIC CODE
<<<<<---------- Begin cutting here.
DIM SHARED HappyFace(51)                        ' This command is what creates
                                                ' our array, which I named
                                                ' HappyFace.

GET (0, 0) - (9, 9), HappyFace                  ' The GET command will copy
                                                ' what is on the screen from
                                                ' X, Y co-ordinates 0, 0 to
                                                ' 9, 9 which is where our
                                                ' happy face is drawn.

---------->>>>> End cutting here.

     Well, we have our happy face stored in an array.  So how do we display
it on the screen? Simple, just do this:

QBASIC CODE
<<<<<---------- Begin cutting here.
PUT (100, 100), HappyFace, PSET                 ' The PUT command will paste
                                                ' our happy face at X ,Y
                                                ' positions, 100, 100 on the
                                                ' screen.  You can change that
                                                ' to put the happy face in any
                                                ' place you want.  You can
                                                ' also use as many PUT commands
                                                ' as you want to create lots
                                                ' of happy faces.

RANDOMIZE TIMER                                 ' This little FOR...NEXT loop
FOR I = 1 to 1000                               ' will place a thousand happy
                                                ' faces all over the screen.
    X = INT(RND * 310)                          ' You can put as many or as
    Y = INT(RND * 190)                          ' few happy faces as you like.
    PUT (X, Y), HappyFace, PSET

NEXT I
---------->>>>> End cutting here.

     So, now you know (More or less) how arrays and graphics work.  But, is it
possible to save my array to a file and recall it later instead of having the
program draw it every time my game starts? you ask.  Yes, it is possible, and
here is how you do it.  Once you have your graphic stored in the array, just
use this code to save it to a file called "HAPPY.GFX".  You can name your file
whatever you want of course...


QBASIC CODE
<<<<<---------- Begin cutting here.
DEF SEG = VARSEG(HappyFace(0))                  ' This will set the pointer to
                                                ' the beginning of the Happy
                                                ' array so Qbasic knows where
                                                ' to begin reading info.  If
                                                ' your graphic is in another
                                                ' array then replace Happy
                                                ' with the name of your array.

BSAVE "HAPPY.GFX", VARPTR(HappyFace(0)), 100    ' This will save the entire
                                                ' graphic in the array to a
                                                ' file called HAPPY.GFX
                                                ' Notice that the 100 at the
                                                ' end is the same as the
                                                ' dimensions of our graphic
                                                ' (10 x 10) multiplied
                                                ' together.  If your graphic
                                                ' is bigger or smaller, just
                                                ' multiply it's dimensions to
                                                ' get the number you need.

DEF SEG                                         ' This statement is not a
                                                ' must but it prevents any
                                                ' small errors which may occur
---------->>>>> End cutting here.

     So, now your graphic is saved.  If you ever want to recall it in any of
your programs, just do this, and remember, you must be in SCREEN 13 for it to
work.  You also must have your array dimensioned.

QBASIC CODE
<<<<<---------- Begin cutting here.
DIM SHARED HappyFace(51)                        ' We must dimension an array
                                                ' to load our graphic.

DEF SEG = VARSEG(HappyFace(0))                  ' We must set the pointer to
                                                ' the beginning of the array
                                                ' so Qbasic knows where to
                                                ' start writing.

BLOAD "HAPPY.GFX", VARPTR(HappyFace(0))         ' This statement will load
                                                ' our happy face graphic into
                                                ' the HappyFace array.  Now
                                                ' you can put it on the
                                                ' screen.

DEF SEG                                         ' Just in case...
---------->>>>> End cutting here.

4.4 NEXT TUTORIAL
-------------------->>>>>
     Well, now you know how to load and save your graphics.  I'm sure that you
want to know more things, like how to put your graphic on the screen without
destroying the background, or how to load GIF files into your games, or maybe
some other small things I haven't convered here.
     There are, of course, other Qbasic tutorials out there which deal with
graphics, much like this one does.  If you explore the 'Net, you'll probably
find some.  But, I will be covering all of the above mentioned things in the
second part of this tutorial.  Hopefully, I'll have it out in two weeks or so.
Well, happy coding...

                        Hail...
                                ... DarkDread

+----------------------------------------------------------------------------+
| RPG Programming Tutorials (Programming RPG's in Qbasic)                    |
| Issue #4 - August/September 1997                                           |
| Copyright (c) 1997 DarkDreams                                              |
| Written by: DarkDread                                                      |
|                                                                            |
| Special Thanks: To everyone who reads these tutorials and to all who have  |
|                 benefitted from them!                                      |
|                                                                            |
| DarkDreams Website:                                                        |
|     http://www.GeoCities.com/SiliconValley/Pines/1732/                     |
|                                                                            |
| This tutorial may be posted anywhere as long as it is left unmodified and  |
| the author is given credit.  The author is not responsible for the use of  |
| these tutorials.                                                           |
+----------------------------------------------------------------------------+


<!-- text below generated by server. PLEASE REMOVE --></applet></object></layer></div></span></style></noscript></table></script>