+------------------------------------------+
|  RPG Programming Tutorial                |
|                                          |
|  June/July 1997                          |
|  Issue #3                                |
|  Released: July 16th, 1997               |
|  Enemy Encounter Engine                  |
+------------------------------------------+

At last, at last.  Here is the enemy encounter tutorial.  Make a note, this
is part 1 of the tutorial.  If all things go according to plan, part 2 should
be out in two weeks (Assuming of course, that it's before July 30th when you
are reading this).  Also, the tutorials will be coming out every two months,
beginning with this issue.

3.1 INTRODUCTION
---------------->>>>

        So, you want to program some enemies into your new RPG.  Well, here's
one way to do it.  For this tutorial, I'll focus mostly on setting up the
enemy encounters.  The second part of this will focus on more detailed aspects
of the enemy encounter engine.

3.2 SETTING UP
---------------->>>>

        Compared to level maps and tile graphics and story boards, an enemy
encounter routine is, for the most part, rather simple.  First, it is useful
to make a list of all of the variables you'll be using in the fight sequences
and write them down on paper so that you know what each does.  For the sake
of simplicity, I'll only use some essential variables for this lesson.  Oh,
and this lesson will only include one player vs. one enemy fights.  Part 2 of
the tutorial will expand on multiple characters/enemies.

So we would make our list like so:

+---------------------------+-------------------------------------+----------+
| Variable name             | Variable description                | Type     |
+---------------------------+-------------------------------------+----------+ 
| HitPoints                 | The player's hit points             | Integer  | 
| MaxHitPoints              | The player's max hit points         | Integer  |
| MagicPoints               | The player's magic points           | Integer  |
| MaxMagicPoints            | The player's max magic points       | Integer  |
| Strength                  | The player's strength               | Integer  |
| Defense                   | The player's defense                | Integer  |
| Experience                | The player's experience             | Long     |
| Gold                      | The player's gold/money/etc.        | Long     |
| Level                     | The player's level                  | Integer  |
| Weapon$                   | The player's weapon                 | String   |
| EnemyName$                | Name of the enemy                   | String   |
| EnemyHP                   | The enemy's hit points              | Integer  |
| EnemyStrength             | The enemy's strength                | Integer  |
| EnemyDefense              | The enemy's defense                 | Integer  |
| EnemyExperience           | Amount of experience gained for     |          |
|                           | defeating the enemy                 | Integer  |
| EnemyGold                 | Amount of money gained for defeating|          |
|                           | the enemy                           |          |
+---------------------------+-------------------------------------+----------+

        In a nutshell, those are the basic variables you will need when making
an enemy encounter routine.  Now we will put our variables to use.

3.3 THE ENCOUNTER
---------------->>>>

        Instead of blathering on and on about what you need to do, I'll just
give you some sample Qbasic code which you can use and optimize.

<<-------------- Qbasic code, begin cutting here.
' For the sake of this tutorial, I'll just put in some stats for the player.
' You should have your character's stats stored in memory or wherever so just
' disregard the next few lines.
HitPoints = 50
MaxHitPoints = 50
MagicPoints = 25
MaxMagicPoints = 25
Strength = 3
Defense = 2
Experience = 0
Gold = 0
Level = 1
Weapon$ = "short sword"

' The next few lines create a random enemy and input the enemy's stats into
' the variables accordingly.
RANDOMIZE TIMER                                 ' This will give us a random
                                                ' number seed.

enemy = INT(RND * 3) + 1                        ' Will produce a random number
                                                ' between 1 and 3.

IF enemy = 1 THEN                               ' This IF block will fill in
        EnemyName$ = "Slime"                    ' the enemy stats based on
        EnemyHP = 10                            ' what number was chosen.
        EnemyStrength = 2                       ' Feel free to experiment by
        EnemyDefense = 2                        ' changing these stats around
        EnemyExperience = 10                    ' and adding more enemies.
        EnemyGold = 8                           ' Just don't forget to add
    ELSEIF enemy = 2 THEN                       ' to the 3 in Enemy = INT(RND
        EnemyName$ = "Skeleton"                 ' * 3) + 1 when you are adding
        EnemyHP = 24                            ' more bad guys.
        EnemyStrength = 4
        EnemyDefense = 1
        EnemyExperience = 20
        EnemyGold = 16
    ELSEIF enemy = 3 THEN
        EnemyName$ = "Warrior"
        EnemyHP = 40
        EnemyStrength = 4
        EnemyDefense = 2
        EnemyExperience = 40
        EnemyGold = 35
END IF

' Now that we have our enemy, let's begin the fight.  For this fight, we'll be
' nice and always let the player go first.

CLS
PRINT "Oh, oh.  Looks like you are being attacked by a "; EnemyName$

DO
    PRINT "What do you want to do? (F)ight, (R)un"
    Choice$ = LCASE$(INPUT$(1))                 ' This line scans the keyboard
                                                ' for player input.

    IF Choice$ = "r" THEN
            RunAway = INT(RND * 2) + 1          ' Give the player a 50/50
                                                ' chance of running away.
            IF RunAway = 1 THEN
                    PRINT "You got away!"
                    done = 1                    ' This is used so that the
                                                ' program will know when the
                                                ' fight is over and exit the
                                                ' loop.
                ELSE
                    PRINT "You couldn't run!"
            END IF
        ELSEIF Choice$ = "f" THEN
            ' Below is a simple equation which will create a random attack
            ' strength based in part on the player's Strength.
            attack = ((INT(RND * 3) + 2) * Strength) - ((INT(RND * 3) + 2) * EnemyDefense)
            IF attack > 0 THEN
                    PRINT "You attack the "; EnemyName$; " with your "; Weapon$; " and do"; attack; "damage!"
                    EnemyHP = EnemyHP - attack  ' This will decrease the
                                                ' enemy's HP by the amount of
                                                ' the player's attack.
                ELSE
                    PRINT "You did no damage!"  ' If the player's attack is
                                                ' less than 1 then no damage
                                                ' will be taken from the
                                                ' enemy.
            END IF
            IF EnemyHP < 1 THEN                 ' This IF block checks to see
                                                ' if the player has defeated
                                                ' the enemy and increases the
                                                ' player's gold/experience if
                                                ' they have.
                    Gold = Gold + EnemyGold
                    Experience = Experience + EnemyExperience
                    PRINT "Yeah! You beat the "; EnemyName$; " and got"; EnemyGold; "gold and"; EnemyExperience; "experience!"
                    done = 1
                ELSE                            ' If the player did not beat
                                                ' the enemy, then the enemy
                                                ' gets to attack.
                    attack = ((INT(RND * 3) + 2) * EnemyStrength) - ((INT(RND * 3) + 2) * Defense)
                    IF attack > 0 THEN
                            PRINT EnemyName$; " attacks and does"; attack; "damage!"
                            HitPoints = HitPoints - attack ' This will decrease the
                                                ' player's HP by the amount of
                                                ' the enemy's attack.
                        ELSE
                            PRINT EnemyName$; " did no damage!"' If the enemy's attack is
                                                ' less than 1 then no damage
                                                ' will be taken from the
                                                ' player.
                    END IF
                    IF HitPoints < 1 THEN       ' This IF block checks to see if the
                                                ' player has no hit points left and
                                                ' exits the LOOP if so.
                        PRINT "You have been defeated by the "; EnemyName$
                        done = 1
                    END IF
            END IF
        ELSE
            PRINT "That is not a valid choice!" ' If the player has selected
                                                ' a choice other than "r" or
                                                ' "f" then they will get a
                                                ' message telling them so.
    END IF
    ' The next line will show the player's hit points after each attack.
    PRINT "HP"; HitPoints; "/"; MaxHitPoints
LOOP UNTIL done = 1                             ' The fight will keep looping
                                                ' until the player has won,
                                                ' or lost, or run away.
------------>>>> End cutting here.

        There you go, a simple enemy encounter routine.  It should be fairly
simple to optimize and add things to it such as spells and multiple hits, etc.


3.4 HOW DO I PUT THIS IN MY PROGRAM?
---------------->>>>

        This part shouldn't be too hard to figure out, but hey, if you want
me to do everything for you then here's one way to do it.  You should make the
routine above into a SUB.  To do this, simply run Qbasic, copy the code, load
up your program, go to the edit menu, and go to the new sub menu.  When it
asks you for a name, you can use whatever you want, as long as it isn't a
Qbasic command, number, etc.  Once you have done this, go to the main loop of
your program (Such as the one where the player walks around on the map) and
insert the following lines (Just don't forget to change CALL Battle to what-
ever name you gave the enemy encounter engine, so if you called it Fight,
then it would be CALL Fight):

EncounterChance = INT(RND * 5) + 1
IF EncounterChance = 1 THEN CALL Battle

As you can see, in these lines, the player has a 1 in 5 chance of meeting an
enemy whenever the program goes through the loop.  The best place to put the
above lines is right after your code for moving the player.  This way, enemies
will only attack when the player moves.

3.5 END NOTES
---------------->>>>

        Well, this concludes another lesson in RPG programming.  I hope that
you have found this enlightening.  Remember, there will be a part 2 to this
tutorial so please don't ask me 'how do I?' questions.  You can give me some
ideas as to what you would like to see in part 2 that is related to enemy
encounters, if I use your suggestion, you will get credit.

3.6 NEXT ISSUE
---------------->>>>

        To tell you the truth, I really don't have too many ideas for the next
issue.  I am thinking about explaining how to put shops and inns and other
town things into it.  If you have any better ideas then feel free to e-mail me
with your suggestions.  Good luck with your RPG programming.  That's it for
now.

                                                                   - DarkDread

+----------------------------------------------------------------------------+
| RPG Programming Tutorials (Programming RPG's in Qbasic)                    |
| Issue #3, June/July 1997                                                   |
| Copyright (c) 1997 DarkDreams                                              |
| Written by: DarkDread                                                      |
|                                                                            |
| This tutorial may be posted anywhere as long as it is left unmodified and  |
| the author is given credit.  The author is not responsible for the use of  |
| these tutorials.                                                           |
+----------------------------------------------------------------------------+


<!-- text below generated by server. PLEASE REMOVE --></applet></object></layer></div></span></style></noscript></table></script>